/* FILE: mstation.h                             (D. Tottingham  09/07/89)

This is an include file of defines, data structure definitions and
external declarations that are common in the mstation module.

*/

#ifndef _MSTATION_
#define _MSTATION_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define NETWORK_NAME            "USGS"
#define STATION_FILENAME        "STATION.@@@"
#define AUTHORITY               101             /* CALNET */


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void st_add_station (char *, char, unsigned int);
PUBLIC int st_build_textline (unsigned int, char *);
PUBLIC int st_get_authority ();
PUBLIC Q_STATION far * st_get_head_station ();
PUBLIC Q_STATION far * st_get_next_station ();
PUBLIC Q_STATION far * st_get_station (unsigned int);
PUBLIC char * st_get_netwname ();
PUBLIC void st_initialize_params ();
PUBLIC void st_initialize_stations ();
PUBLIC void st_set_authority (int);
PUBLIC void st_set_gain (unsigned int, unsigned int);
PUBLIC void st_set_netwname (char *);

#endif
